/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ToolStatsModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class BlacksmithModifier
extends Modifier
implements ToolStatsModifierHook,
MeleeDamageModifierHook,
TooltipModifierHook,
ConditionalStatModifierHook {
    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOL_STATS, ModifierHooks.MELEE_DAMAGE, ModifierHooks.TOOLTIP, ModifierHooks.CONDITIONAL_STAT});
    }

    public void addToolStats(IToolContext context, ModifierEntry modifier, ModifierStatsBuilder builder) {
        ToolStats.DURABILITY.multiply(builder, 1.0 + 0.08 * (double)modifier.getLevel());
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        LivingEntity living = context.getAttacker();
        if (living.m_20186_() <= 64.0 && living.m_20186_() >= 0.0) {
            return (float)((double)damage * (1.0 + (64.0 - living.m_20186_()) * 0.008));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (living.m_20186_() <= 64.0 && living.m_20186_() >= 0.0 && stat == ToolStats.VELOCITY) {
            return (float)((double)baseValue * (1.0 + (64.0 - living.m_20186_()) * 0.016));
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if (player != null && harvest || player != null && tool.hasTag(TinkerTags.Items.RANGED)) {
            double y = player.m_20186_();
            if (tooltipKey == TooltipKey.SHIFT && y >= 0.0 && y <= 64.0) {
                if (harvest) {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.blacksmith.attack_damage"), (double)((64.0 - y) * 0.0016), tooltip);
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.blacksmith.attack_speed"), (double)(1.0 - (64.0 - y) * 0.0016), tooltip);
                } else {
                    TooltipModifierHook.addPercentBoost((Modifier)modifier.getModifier(), (Component)Component.m_237115_((String)"modifier.tinkerscalibration.blacksmith.velocity"), (double)((64.0 - y) * 0.016), tooltip);
                }
            }
        }
    }
}

